package ibase.e12ria.client;

import java.util.ArrayList;
import java.util.HashMap;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style.Display;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ErrorEvent;
import com.google.gwt.event.dom.client.ErrorHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;

import ibase.e12ria.client.resources.Resources;
import ibase.e12ria.e12widgets.client.E12CheckBox;
import ibase.e12ria.e12widgets.shared.E12CommonUtils.DeviceOS;

/**
 * Add button for Logout,Close,ChangePassword and HideMenu.
 * It also display user information in welcome message link.  
 * @author user
 */
 //Added By Prajyot Rumde On 11-08-2011 [RnD]
public class E12HeaderPanel extends ResizeComposite {
	
	private final I18NConstants constants = GWT.create( I18NConstants.class );

	private static E12HeaderPanelUiBinder uiBinder = GWT.create( E12HeaderPanelUiBinder.class );
	
	private static final ImageResource HIDE_MENU_IMG = Resources.INSTANCE.hideMenuImg();
	private static final ImageResource SHOW_MENU_IMG = Resources.INSTANCE.showMenuImg();
	private static final ImageResource DEFAULT_USER_IMG = Resources.INSTANCE.userImage(); //White shadow image with colored background 
	private static final ImageResource USER_SETTING = Resources.INSTANCE.userSettings();
//	private static final ImageResource NOTIFY_IMG = Resources.INSTANCE.notifyImage();  
	private static final ImageResource GALAXY_USER_IMG = Resources.INSTANCE.galaxyUserImage();
	public static String tagLine = "";
	
	interface E12HeaderPanelUiBinder extends UiBinder< Widget, E12HeaderPanel > {
	}
	
	//@UiField static ToggleButton hideShowMenu;
//	@UiField Button closePanel; //Commented by Nilesh Soor on 25-Aug-14
	//@UiField Hidden showMessage;
	@UiField static Image userImageHB;
	// Added by Pankaj R on 26-Oct-17 to show client logo basd on enterprise value
	@UiField static Image e12Logo;
	//@UiField Hyperlink welcomeMsgLink; 
	@UiField static Image userSetting;
	@UiField E12ShortcutPanel e12ShortcutPanel;//Added by Nilesh Soor on 25-Aug-14
	@UiField HTMLPanel headerDiv;
	@UiField static Image workflow;
	@UiField E12ApplicationMenuBar e12ApplicationMenuBar;
	@UiField HTMLPanel userNamePanel;
	//Change by shrutika on 28-03-19 for Implement on shift + tab functionality to switch open tab.
	//@UiField static E12NavigateTabBar e12NavigateTabBar;
	@UiField public static E12NavigateTabBar e12NavigateTabBar;
	//@UiField E12NavigateTabBar e12NavigateTabBar;
	@UiField HTMLPanel taglineMetis ; // Added by Shivaji on on 26-May-2015 [ To add Tag Line ]
	
	static boolean isFullScreen;
	static String userImageClass = "";
	static E12CheckBox hideShowMenu;

	//@UiField(provided=true) Button notifyButton;
	//Notification notification = new Notification();
	//@UiField Image notifyImage;
	
	//PopupPanel popupNotifyPnl = notification.popupPnl;
	PopupPanel userPopupPnl;
	VerticalPanel vPnl;
	HorizontalPanel hPnl;
	VerticalPanel mainPanel;
	E12UserInfo e12UserInfo;
	E12UserSetting e12UserSetting;
	static Image usrImgRef = null;/* *Added by Dnyaneshwar Chavan on 11-Sep-15 [User should be change the his profile image in galaxy theme in browser interface.] Start */
	
	@UiField static Image home;
	@UiField static Image help;
	@UiField public static Image social;//Changed to public by Pravin K on 11-8-17 [To hide social icon]
	//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ]
	@UiField public static Image devloperConsole;
	@UiField public static HorizontalPanel minimizeTransPanel;  //Added by Sandeep S. on 09-AUG-18 [To implement minimize transaction popup in browser]

	@UiField public static Label socialPending ;//Added by Pravin K on 23-JAN-19 [for social count]  
	
	/**
	 * Initialize the UiBinder and set text on all Button.
	 */
	public E12HeaderPanel() {
		E12CommonUtils.printOnConsole(".........HDR 3.1");
		E12CommonUtils.getInstance().getWorkFlowPendingCount(0);
		//Added By Mahesh Patidar on 05/MAR/13
		//notifyButton = notification.messageLabel;
		//notifyButton.setStyleName("notifyButton");
//		notification.login(E12Constants.userID);
//		notification.loadMessages(E12Constants.userID, "Y");
		//Ended By Mahesh Patidar
	
		hideShowMenu = new E12CheckBox( DeviceOS.Other );
		hideShowMenu.getElement().setId("e12headrPnl-hideShow");
		hideShowMenu.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				hideShowMenuClick();				
			}
		});
		initWidget( uiBinder.createAndBindUi( this ) );
		// Added by Shivaji on 26-May-2015 [To add Tag Line ]-Start
		if( E12Global.isGalaxy() )
		{	
			taglineMetis.add( getTagLinePanel() );
		}
		// Added by Shivaji on 26-May-2015 [To add Tag Line ]-End
		hideShowMenu.setTitle(E12Constants.constants.setClickShowHide()); // Modified by Raju K on 20-12-13 for I18N
		E12CommonUtils.printOnConsole(".........HDR 3.1.a");
		hPnl = new HorizontalPanel();
		hPnl.setSpacing(5);
		
		E12Constants.userID = DOM.getElementById( "userID" ).getInnerText();
		E12Constants.allowChgAccount = DOM.getElementById( "allowChgAccount" ).getInnerText();
		//Changed By Pankaj T on 21-09-17 for userinfo object access on class level 
		e12UserInfo = E12SearchBar.e12UserInfo;
		//e12UserInfo = new E12UserInfo();
		e12UserSetting = new E12UserSetting();
		E12CommonUtils.printOnConsole(".........HDR 3.1.b");
		// Commented by Raju K on 14-10-14  [To create the browser short cut panel] End--
		mainPanel = new VerticalPanel();
		e12ShortcutPanel.add( mainPanel );
		e12ShortcutPanel.setStyle("custome");
		//Added by Nilesh Soor on 25-Aug-14 END
		E12CommonUtils.printOnConsole(".........HDR 3.1.c");
		userSetting.setResource( USER_SETTING );
		userSetting.setStyleName("header-userSetting theme-" + E12Constants.userTheme );
		E12CommonUtils.printOnConsole(".........HDR 3.1.d");
		if(E12Global.isGalaxy())
		{
			userImageHB.setResource( GALAXY_USER_IMG );
		}
		else
		{
			userImageHB.setResource( DEFAULT_USER_IMG );
		}
		userImageHB.setStyleName("header-defaultUserImage theme-" + E12Constants.userTheme );
		userImageHB.getElement().setId("e12hdrPnl-userImageHB");
		userImageClass = "header-defaultUserImage ";
		E12CommonUtils.printOnConsole(".........HDR 3.1.e");
		if ( ! ( Window.Navigator.getAppVersion().contains( "MSIE 7.0" ) || Window.Navigator.getAppVersion().contains( "MSIE 8.0" ) ) )
		{
			//changes by Ajinkya Gopalkar on 13-FEB-15 [save uploaded images to path]
			
			//Changed by Reema on 18-mar-15 [Change User image path]
//			userImageHB.setUrl( E12Global.getHostUrl() +"/ibase/images/userImages/"+E12Constants.userID+".png" );
			
			//Changed by Shivaji on 25-05-2015 [ To change images path]-Start
			//userImageHB.setUrl( E12Global.getHostUrl() + "/ibase/resource/" + E12Constants.userID + "/" + E12Constants.userID + ".png" );
			userImageHB.setUrl( E12Global.getHostUrl() + "/ibase/resource/images/users/" + E12Constants.userID + ".jpg?"+Math.random() );
			//Changed by Shivaji on 25-05-2015 [ To change images path]-End
			
			//Changed by Reema on 18-mar-15 [Change User image path]-End
			userImageHB.setTitle(E12Constants.constants.setClickToLogout()); //Modified by Raju K on 20-12-13 [I18N]
			userImageHB.setStyleName("header-userImage theme-" + E12Constants.userTheme );
			userImageClass = "header-userImage ";
		}
		//Added by Dnyaneshwar on 23-JUL-13 [ when browser is 'IE8' then display only default user image as per KBSir ] End
		userImageHB.addErrorHandler(new ErrorHandler() {
			
			@Override
			public void onError(ErrorEvent event) {
				// Changed by Shivaji on 01-06-2015 [to read png or jpg image]-Start
				userImageHB.setUrl( E12Global.getHostUrl() + "/ibase/resource/images/users/" + E12Constants.userID + ".png?"+Math.random() );
				userImageHB.setTitle(E12Constants.constants.setClickToLogout()); 
				userImageHB.setStyleName("header-userImage theme-" + E12Constants.userTheme );
				userImageClass = "header-userImage ";
				
				userImageHB.addErrorHandler(new ErrorHandler() {
					
					@Override
					public void onError(ErrorEvent event) {
				
						if(E12Global.isGalaxy())
						{
							userImageHB.setResource( GALAXY_USER_IMG );
						}
						else
						{
							userImageHB.setResource( DEFAULT_USER_IMG );
						}
						userImageHB.setTitle(E12Constants.constants.setClickToLogout()); //Modified by Raju K on 20-12-13 [I18N]
						userImageHB.setStyleName("header-defaultUserImage theme-" + E12Constants.userTheme );
						userImageHB.getElement().setId("e12HeaderPnl-userImg-err");
						userSetting.setStyleName("header-userSetting theme-" + E12Constants.userTheme );
						userImageClass = "header-defaultUserImage ";
				
					}
				});
				// Changed by Shivaji on 01-06-2015 [to read png or jpg image]-End
			}
		});
		//Changes as per Client Mail [ 14-AUG-2013 : Nilesh Parikh ]
		//userImage.setTitle( "More information about logged in user and option to logout & change password " );
		userImageHB.setTitle(E12Constants.constants.setClickToLogout()); //Modified by Raju K on 20-12-13 [I18N]
		userSetting.setTitle(E12Constants.constants.setClickForSetting()); 
		userImageHB.getElement().setId("userImageHP");
		
		
		E12CommonUtils.printOnConsole(".........HDR 3.1.f");
		/*notifyImage.setResource(NOTIFY_IMG);
		notifyImage.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				notifyButton.click();
			}
		});
		notifyImage.setStyleName("notifyImage");*/
		E12CommonUtils.printOnConsole(".........HDR 3.1.g");
		workflow.setResource(Resources.INSTANCE.workflowGrayImg());
		workflow.setStyleName("header-workflowImg");
		workflow.setTitle(E12Constants.constants.setWorkflowLbl());
		workflow.getElement().setId("e12HdrPnl-wrkFlw");
		workflow.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				workflow.setResource(Resources.INSTANCE.workflowImg());
			}
		});
		workflow.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				workflow.setResource(Resources.INSTANCE.workflowGrayImg());
			}
		});
		
		home.setResource(Resources.INSTANCE.homeImg());
		home.setStyleName("header-workflowImg");
		home.setTitle(E12Constants.constants.setHomeLbl());
		home.getElement().setId("e12HdrPnl-home");
		home.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				home.setResource(Resources.INSTANCE.homeImg());
			}
		});
		home.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				home.setResource(Resources.INSTANCE.homeImg());
			}
		});
		
		help.setResource(Resources.INSTANCE.helpGrayImg());
		help.setStyleName("header-workflowImg");
		help.setTitle(E12Constants.constants.sethelpInfoLbl());
		help.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				help.setResource(Resources.INSTANCE.helpImg());
			}
		});
		help.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				help.setResource(Resources.INSTANCE.helpGrayImg());
			}
		});
		
		//Added by Prajyot on 06AUG2015[W15DSUN015 - Social Enterprise Platform]
		social.setResource(Resources.INSTANCE.socialGrayImg());
		social.setStyleName("header-workflowImg");
		social.setTitle(E12Constants.constants.setSocialInfoLbl());
		social.getElement().setId("e12HdrPnl-social");
		//Added by Jay - To set the display SociaL enterprise on the basis of Soical_opt - [Start]
		String socialOpt = E12Constants.social_opt;
		E12CommonUtils.printOnConsole("social_opt value while adding in div: ["+socialOpt+"]");
		
		if (socialOpt != null && socialOpt.equals("0")) 
		{
		    social.getElement().getStyle().setDisplay(Display.NONE);
		}
		//Added by Jay - To set the display SociaL enterprise on the basis of Soical_opt - [End]

		social.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				social.setResource(Resources.INSTANCE.socialImg());
			}
		});
		social.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				social.setResource(Resources.INSTANCE.socialGrayImg());
			}
		});
		
		//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] Start
		devloperConsole.setResource(Resources.INSTANCE.devloperConsoleGrayImg());
		devloperConsole.setStyleName("header-workflowImg");
		devloperConsole.setTitle(E12Constants.constants.setDevloperConsoleLbl());
		devloperConsole.getElement().setId("e12HdrPnl-devloper");
		devloperConsole.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				devloperConsole.setResource(Resources.INSTANCE.devloperConsoleImg());
			}
		});
		devloperConsole.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				devloperConsole.setResource(Resources.INSTANCE.devloperConsoleGrayImg());
			}
		});
		//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] End
		userNamePanel.add(getUserNamePanel());
		userNamePanel.getElement().setId("e12headrPnl-userName");
		userNamePanel.addDomHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				e12UserInfo.clickOnUserNamePanel( userNamePanel.getAbsoluteLeft() );				
			}
		}, ClickEvent.getType());
		userNamePanel.setStyleName("header-userNamePanel");
		userNamePanel.getElement().setId("header-userNamePanelID");
		updateHeader();
		//Added by Sandeep S. on 09-AUG-18 [To implement minimize transaction popup in browser]
		minimizeTransPanel.addStyleName("minimizeTransPanel");
	}
	
	@UiHandler("userImageHB")
	void onUserImageHB(ClickEvent event)
	{
		e12UserInfo.clickOnUserImage( userImageHB.getAbsoluteLeft() );
	}
	
	@UiHandler ("userSetting")
	void onUserSettings(ClickEvent event)
	{
		e12UserSetting.clickOnUserSettings( userSetting.getAbsoluteLeft(), isFullScreen );
	}
	
	//Commented by Nilesh Soor on 25-Aug-14
	/**
	 * HideShow menu button used for hiding or showing Menu panel.
	 * Onclick of Hide Menu it will hide Menu panel and Resize the TransBrow Panel.
	 * @param event
	 */
//	@UiHandler( "hideShowMenu" )
	void hideShowMenuClick()
	{
		isFullScreen = hideShowMenu.getValue();
		Widget menuPanel = BaseE12.e12SplitLytPanel.getWidget( 0 );
		if( hideShowMenu.getValue() )
		{
			E12CommonUtils.printOnConsole("isfullscreen");
			BaseE12.e12SplitLytPanel.setWidgetSize(menuPanel, 0);
			BaseE12.e12SplitLytPanel.forceLayout();
		}
		else
		{
			BaseE12.e12SplitLytPanel.setWidgetSize(menuPanel, 210);
			BaseE12.e12SplitLytPanel.forceLayout();
		} 
	}
	/**
	 * It will add Hyperlink of welcome msg.
	 * Onclick of 'welcomeMsgLink' it will display the user information.
	 * @param event
	 */
	//Commented by Dnyaneshwar on 19/JAN/13 [Remove the notification module] Start
	/*//Added By Mahesh Patidar On 02/JAN/13 for Implement the Message Popup Panel
	@UiHandler("notifyButton") 
	void onMessagePanel(ClickEvent event)
	{
		Widget widget=(Widget)event.getSource();
		int left=widget.getAbsoluteLeft()-140;
		int top=widget.getAbsoluteTop()+16;
		
		popupNotifyPnl.setPopupPosition(left, top);
		
		if(notification.msgPanel.getWidgetCount() > 0)
		{
			popupNotifyPnl.setStylePrimaryName("msgPopupPanel");
			popupNotifyPnl.show();
		}
	}
	//Ended By Mahesh Patidar
*/
	//Commented by Dnyaneshwar on 19/JAN/13 [Remove the notification module] End
	/**
	 * This method return a image of hide menu
	 * 
	 * @return Image is object of Image class
	 * */
	public Image getHideMenuImg()
	{
		return new Image(HIDE_MENU_IMG);
	}
	
	/**
	 * This method return a image of show menu
	 * 
	 * @return Image is object of Image class
	 * */
	public Image getShowMenuImg()
	{
		return new Image(SHOW_MENU_IMG);
	}

	//Added By Prajyot on 6-JUN-2013
	private void closeOtherClick(int selectedTab)
	{
		VerticalPanel e12PnlGen = ( VerticalPanel )( BaseE12.e12TransBrow.e12TabPanel.getWidget( selectedTab ) );
		
		//Changed By Prajyot P. Rumde on 11-08-2011 [RnD]
		//String title = ( BaseE12.e12TransBrow.e12TabPanel.getTabBar().getTabHTML( selectedTab ) );
		
		//Changes by Prajyot on 4JUN13 [Bug fixing : On click of Close Other, other than selected tabs get close and title of Selected tab gets changed ]
		//String title = ( BaseE12.e12TransBrow.e12TabPanel.getTabHTML( selectedTab ) );
		String title = BaseE12.e12TransBrow.e12TabPanel.getTabTitle(selectedTab);
		do
		{
			try
			{
				TextBox tbID = ( TextBox ) e12PnlGen.getWidget( 1 );
				String selectRandID = ( String )BaseE12.tabsMap.get( E12Constants.userID + tbID.getText().trim() );
				do
				{
					VerticalPanel e12PnlGen1 = ( VerticalPanel ) BaseE12.e12TransBrow.e12TabPanel.getWidget( 1 );
					TextBox tbID1 = ( TextBox ) e12PnlGen1.getWidget( 1 );
					
					//Changed By Mahesh Patidar on 28/DEC/12
					HashMap<String, String> paramMap = new HashMap<String, String>();
					
					paramMap.put("EDITOR_ID", BaseE12.tabsMap.get( E12Constants.userID + tbID1.getText().trim() ));
					paramMap.put("dummyInt", ""+Math.random());
					String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
					
					//String path = MELogin.hostUrl +"/ibase/InstanceRemoveServlet?" + paramString;
					String path = E12Global.getHostUrl() +"/ibase/InstanceRemoveServlet?" + paramString;
					//	String path =MELogin.hostUrl + "/ibase/InstanceRemoveServlet?EDITOR_ID=" + BaseE12.tabsMap.get( E12Constants.userID + tbID1.getText().trim() )  + "&dummyInt=" + Math.random();
					RequestBuilder requestBuilder = new RequestBuilder( RequestBuilder.GET,path );
					try 
					{
						requestBuilder.sendRequest( null, new RequestCallback() 
						{
							public void onError( Request request, Throwable exception ) 
							{
								Window.alert( constants.setErrMsgAlt() );
							}
							public void onResponseReceived( Request request, Response response ) 
							{
								// Added BY Arvind on 7-FEB-2014 : To Maintain session time out
								if( E12Global.getInstance().checkErrorException(response, 1) )
								{
									GWT.runAsync( new RunAsyncCallback() 
									{
										public void onSuccess() 
										{
										}
										public void onFailure( Throwable reason ) 
										{
//											Changed by Savita Yadav on 18-05-2015 [For Code download terminated issue]
//											Window.alert( constants.setErrMsgAlt() + " :: " + reason.getMessage() );
											Window.alert( constants.setClearCacheAndLogin() );         
										}
									});
								}
							}
						});
					} 
					catch ( RequestException ex ) 
					{
						Window.alert( constants.setExceptionAlt() + " " + ex.getMessage() + "]" );
						System.out.println( constants.setExceptionAlt() + " : " + ex.getMessage() );
					}
			
					//Changed By Prajyot P. Rumde on 11-08-2011 [RnD]
					//e12PnlGen1.removeFromParent();
					e12PnlGen1 = null;
					//Added By Prajyot P. Rumde on 11-08-2011 [RnD]
					BaseE12.e12TransBrow.e12TabPanel.remove(1);
					
					BaseE12.tabsMap.remove( E12Constants.userID+tbID1.getText().trim() );
					BaseE12.e12TransBrow.e12TabPanel.selectTab( 0 );
				}
				while( BaseE12.e12TransBrow.e12TabPanel.getWidgetCount() != 1 );
				
				//Changes by Prajyot on 4JUN13 [Bug fixing : On click of Close Other, other than selected tabs get close and title of Selected tab gets changed ] 
				//BaseE12.e12TransBrow.e12TabPanel.insert( e12PnlGen, title, 1 );
				//BaseE12.e12TransBrow.e12TabPanel.insert( e12PnlGen, new BaseE12(true).getTabWidget( e12PnlGen, title ), 1 );
				
				BaseE12.tabsMap.put( E12Constants.userID + tbID.getText().trim(), selectRandID );
				//BaseE12.e12TransBrow.e12TabPanel.selectTab( 1 );
			}
			catch(Exception e){
				BaseE12.e12TransBrow.e12TabPanel.remove(1);
				BaseE12.e12TransBrow.e12TabPanel.selectTab( 0 );				
			}	
			
		}while( BaseE12.e12TransBrow.e12TabPanel.getWidgetCount() != 1 );
		BaseE12.e12TransBrow.e12TabPanel.insert( e12PnlGen, new BaseE12(true).getTabWidget( e12PnlGen, title ), 1 );
		BaseE12.e12TransBrow.e12TabPanel.selectTab( 1 );
	}
	
	private void closeAllClick()
	{
		try 
		{
			do
			{
				try
				{						
					//Window.alert("Close All" + BaseE12.e12TransBrow.e12TabPanel.getWidgetCount());
					VerticalPanel e12PnlGen = ( VerticalPanel )( BaseE12.e12TransBrow.e12TabPanel.getWidget( 1 ) );
					TextBox tbID = ( TextBox ) e12PnlGen.getWidget( 1 );
	
					//Changed By Mahesh Patidar on 28/DEC/12
					HashMap<String, String> paramMap = new HashMap<String, String>();
	
					paramMap.put("EDITOR_ID", BaseE12.tabsMap.get( E12Constants.userID+tbID.getText().trim() ));
					paramMap.put("OBJ_NAME", E12Constants.objName);
					paramMap.put("dummyInt", ""+Math.random());
					String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
					
					//String path = MELogin.hostUrl +"/ibase/InstanceRemoveServlet?" + paramString;
					String path = E12Global.getHostUrl() +"/ibase/InstanceRemoveServlet?" + paramString;
	//				String path = MELogin.hostUrl +"/ibase/InstanceRemoveServlet?EDITOR_ID=" + BaseE12.tabsMap.get( E12Constants.userID+tbID.getText().trim() ) + "&OBJ_NAME=" + E12Constants.objName  + "&dummyInt=" + Math.random();
					//Ended By Mahesh Patidar
					RequestBuilder requestBuilder = new RequestBuilder( RequestBuilder.GET,path );
					try 
					{
						requestBuilder.sendRequest( null, new RequestCallback() 
						{
							public void onError( Request request, Throwable exception ) 
							{
								Window.alert( constants.setErrMsgAlt() );
							}
							public void onResponseReceived( Request request, Response response ) 
							{
								// Added BY Arvind on 7-FEB-2014 : To Maintain session time out
								if( E12Global.getInstance().checkErrorException(response, 1) )
								{
									GWT.runAsync( new RunAsyncCallback() 
									{
										public void onSuccess() 
										{
										}
										public void onFailure( Throwable reason ) 
										{
//											Changed by Savita Yadav on 18-05-2015 [For Code download terminated issue]
//											Window.alert( constants.setErrMsgAlt() + " :: " + reason.getMessage() );
											Window.alert( constants.setClearCacheAndLogin() );       
										}
									});
								}
							}
						});
					} 
					catch ( RequestException ex ) 
					{
						Window.alert( constants.setExceptionAlt() + " " + ex.getMessage() + "]" );
						System.out.println( constants.setExceptionAlt() + " : " + ex.getMessage() );
					}

					BaseE12.tabsMap.remove( E12Constants.userID+tbID.getText().trim() );
				
					//Changed By Prajyot P. Rumde on 11-08-2011 [RnD]
					//e12PnlGen.removeFromParent();
					e12PnlGen = null;
					//Added By Prajyot P. Rumde on 11-08-2011 [RnD]
					BaseE12.e12TransBrow.e12TabPanel.remove(1);	
									
					BaseE12.e12TransBrow.e12TabPanel.selectTab( 0 );
				}
				catch(Exception ex){
					BaseE12.e12TransBrow.e12TabPanel.remove(1);	
					BaseE12.e12TransBrow.e12TabPanel.selectTab( 0 );
				}
			}
			while( BaseE12.e12TransBrow.e12TabPanel.getWidgetCount() != 1 ); 
		}
		catch (Exception e) 
		{
			Window.alert("Exception in E12HeaderPanel onCloseAll [" + e.getMessage() + "]");
		}
	}
	
	// Added by Raju K on 14-10-14  [To create the browser short cut panel] Start-- 
	/**
	 * This method is used  to create the shortcut panel for browser home page
	 * @return
	 */
	ArrayList<HashMap<String, String>> linksMapList = new ArrayList<HashMap<String,String>>();
	public void initBrowShortPanel(String configXml)
	{
		//Changes by Ajinkya Gopalkar on 17-Jun-15[for added links into shortcut panel dynamically using e12config xml]
		if(!"false".equalsIgnoreCase(configXml))
		{
			Document document = XMLParser.parse(configXml);
			XMLParser.removeWhitespace(document);
			NodeList linkNodeLst = document.getElementsByTagName("Link");
			if (linkNodeLst.getLength() > 0) 
			{
				for (int i = 0; i < linkNodeLst.getLength(); i++) 
				{
					HashMap<String, String> linkWrapper = new HashMap<String, String>();
					Node linkNode = linkNodeLst.item(i);
					NodeList linkChildNodeLst = linkNode.getChildNodes();
					for (int j = 0; j < linkChildNodeLst.getLength(); j++) 
					{
						Node linkChildNode = linkChildNodeLst.item(j);
						String nodeName = linkChildNode.getNodeName();
						String nodeVal = linkChildNode.getFirstChild().getNodeValue().toString();
						linkWrapper.put(nodeName, nodeVal);
					}
					linksMapList.add(linkWrapper);
				}
 			}
		}
		createBrowShortPannel();
	}
	
	//Added by Ajinkya Gopalkar on 17-Jun-15[for added links into shortcut panel dynamically using e12config xml] Start
	private void createBrowShortPannel()
	{
		if(linksMapList != null && linksMapList.size() > 0)
		{
			Label linksLabel = new Label( constants.setLinksLbl() );
			E12CommonUtils.printOnConsole("**** linksLabel["+linksLabel+"]");
			linksLabel.addStyleName( "browShortPanel" );
			mainPanel.add(linksLabel);
			VerticalPanel metisPanel = new VerticalPanel();
			for(HashMap<String, String> linkMap : linksMapList)
			{
				Label linkLabel = new Label( linkMap.get("displayText"));//displayText
				final String gwtURl = E12Global.getHostUrl() + linkMap.get("url"); //url
				E12CommonUtils.printOnConsole("**** linkLabel["+linkLabel+"] gwtURl["+gwtURl+"]");
				linkLabel.addStyleName( "labelForShortPanel" );
				metisPanel.add( linkLabel );
				linkLabel.getElement().setId("e12headrPnl-link");
				linkLabel.addClickHandler( new ClickHandler() 
		        {
					@Override
					public void onClick( ClickEvent event ) 
					{
						
						e12ShortcutPanel.popupPanel.hide( true ); 
						Window.open( gwtURl, "About Metis", "" );
					}
				});
			}
			mainPanel.add( metisPanel );
		}
		//Added by Ajinkya Gopalkar on 17-Jun-15[for added links into shortcut panel dynamically using e12config xml] End
		Label otherActLabel = new Label( constants.setOthActLbl() );
		otherActLabel.addStyleName( "browShortPanel" );
		mainPanel.add(otherActLabel);
		
		VerticalPanel otherPanel = new VerticalPanel();
		Label closeAll = new Label( constants.setCloseAllLbl() );
        Label closeOthers = new Label( constants.setCloseOtherLbl() );
        closeAll.addStyleName( "labelForShortPanel" );
        closeOthers.addStyleName( "labelForShortPanel" );
        
        otherPanel.add( closeAll );
        otherPanel.add( closeOthers );
        mainPanel.add( otherPanel );
        
        closeAll.getElement().setId("e12headrPnl-closeAll");
        closeAll.addClickHandler( new ClickHandler() 
		{
			@Override
			public void onClick( ClickEvent event ) 
			{
				if( BaseE12.e12TransBrow.e12TabPanel.getWidgetCount() > 1 )
				{
					e12ShortcutPanel.popupPanel.hide( true );
					closeAllClick();
				}
			}
		});
		
        closeOthers.getElement().setId("e12headrPnl-close");
		closeOthers.addClickHandler( new ClickHandler()
		{
			public void onClick( ClickEvent event )
			{
				try 
				{
					if( BaseE12.e12TransBrow.e12TabPanel.getWidgetCount() > 1 )
					{
						int selectedTab = BaseE12.e12TransBrow.e12TabPanel.getSelectedTab();
						e12ShortcutPanel.popupPanel.hide( true );
						if( selectedTab != 0 )
						{
							closeOtherClick( selectedTab );
						}
						else
						{
							closeAllClick();
						}
					}
				} 
				catch (Exception e) 
				{
					Window.alert("Exception in E12HeaderPanel onCloseOther [" + e.getMessage() + "]");
				}
			}	
		});
	}
	// Added by Raju K on 14-10-14  [To create the browser short cut panel] End-- 
	
	@UiHandler ( "workflow" )
	void onWorkflow(ClickEvent event)
	{
		e12ApplicationMenuBar.selectApplication("WRK_OPT");
		//Changed by Nilesh Soor on 31/12/2014 [ Taggle button change icon ] START
		workflow.setResource(Resources.INSTANCE.workflowImg());
		home.setResource(Resources.INSTANCE.homeGrayImg());
		help.setResource(Resources.INSTANCE.helpGrayImg());
		social.setResource(Resources.INSTANCE.socialGrayImg());
		//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] 
		devloperConsole.setResource(Resources.INSTANCE.devloperConsoleGrayImg());
		//BaseE12.e12MenuPanel.updateAccordins("WORKFLOW");
		//Changed by Nilesh Soor on 31/12/2014 [ Taggle button change icon ] END
		workflow.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				workflow.setResource(Resources.INSTANCE.workflowImg());
			}
		});
		workflow.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				workflow.setResource(Resources.INSTANCE.workflowImg());
			}
		});
		home.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				home.setResource(Resources.INSTANCE.homeImg());
			}
		});
		home.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				home.setResource(Resources.INSTANCE.homeGrayImg());
			}
		});
		help.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				help.setResource(Resources.INSTANCE.helpImg());
			}
		});
		help.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				help.setResource(Resources.INSTANCE.helpGrayImg());
			}
		});
		//Added by Prajyot on 06AUG2015[W15DSUN015 - Social Enterprise Platform]
		social.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				social.setResource(Resources.INSTANCE.socialImg());
			}
		});
		social.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				social.setResource(Resources.INSTANCE.socialGrayImg());
			}
		});
		//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] Start
		devloperConsole.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				devloperConsole.setResource(Resources.INSTANCE.devloperConsoleImg());
			}
		});
		devloperConsole.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				devloperConsole.setResource(Resources.INSTANCE.devloperConsoleGrayImg());
			}
		});
		//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] End
	}

	public HorizontalPanel getUserNamePanel()
	{
		final Image userImage = new Image();
		usrImgRef = userImage;/* *Added by Dnyaneshwar Chavan on 11-Sep-15 [User should be change the his profile image in galaxy theme in browser interface.] Start */
		if(E12Global.isGalaxy())
		{
			userImage.setResource( GALAXY_USER_IMG );
		}
		else
		{
			userImage.setResource( DEFAULT_USER_IMG );
		}
		userImage.setStyleName("header-defaultUserImage theme-" + E12Constants.userTheme );
		userImage.getElement().setId("e12hdrPnl-userImage");
		E12CommonUtils.printOnConsole(".........userNameHoriPanel 3.1.e");
		//Added by Dnyaneshwar on 23-JUL-13 [ when browser is 'IE8' then display only default user image as per KB Sir ] 
		if ( ! ( Window.Navigator.getAppVersion().contains( "MSIE 7.0" ) || Window.Navigator.getAppVersion().contains( "MSIE 8.0" ) ) )
		{
			//Changed by Reema on 18-mar-15 [Change User image path]
//			userImage.setUrl( E12Global.getHostUrl() +"/ibase/images/"+E12Constants.userID+".png" );
		
			//Changed by Shivaji on 25-05-2015 [ To change images path]-Start
			//userImage.setUrl( E12Global.getHostUrl() + "/ibase/resource/" + E12Constants.userID + "/" + E12Constants.userID + ".png" );
			userImage.setUrl( E12Global.getHostUrl() + "/ibase/resource/images/users/" + E12Constants.userID + ".jpg?"+Math.random() );
			//Changed by Shivaji on 25-05-2015 [ To change images path]-End
			
			//Changed by Reema on 18-mar-15 [Change User image path]-End
			//userImage.setTitle(E12Constants.constants.setClickToLogout()); 
			userImage.setStyleName("header-userImage theme-" + E12Constants.userTheme );
		}

		userImage.addErrorHandler(new ErrorHandler() {
			
			@Override
			public void onError(ErrorEvent event) {
				// Changed by Shivaji on 01-06-2015 [to read png or jpg image]-Start
				userImage.setUrl( E12Global.getHostUrl() + "/ibase/resource/images/users/" + E12Constants.userID + ".png?"+Math.random() );
				userImage.addErrorHandler(new ErrorHandler() {
					
					@Override
					public void onError(ErrorEvent event) {
						if(E12Global.isGalaxy())
						{
							userImage.setResource( GALAXY_USER_IMG );
						}
						else
						{
							userImage.setResource( DEFAULT_USER_IMG );
						}
						//userImage.setTitle(E12Constants.constants.setClickToLogout());
						userImage.getElement().setId("e12hdrPnl-userImage-err");
						userImage.setStyleName("header-defaultUserImage theme-" + E12Constants.userTheme );
					}
				});
				// Changed by Shivaji on 01-06-2015 [to read png or jpg image]-End
			}
		});

		//String userName =  DOM.getElementById("empFName").getInnerText() + " " + DOM.getElementById("empLName").getInnerText();
		//Added by sunny soni for showing users profile name[Start]
		String userName =  DOM.getElementById("userName").getInnerText();
		//Added by sunny soni for showing users profile name[End]
		userName = userName.toLowerCase();		
		Label userNameLbl = new Label(userName);
		userNameLbl.setStyleName("empNameLbl");
		userNameLbl.addStyleName("dropdown");
		userNameLbl.getElement().setId("e12HeaderPnl-userNameLbl");
		
		//Added By Prajyot on 05-JUN-2015 [Entity Contact Details for SSP]
	  	//Change By Ajinkya Gopalkar on 13-OCT-15[for displaying profileDescr]
		//String entityDescr =  DOM.getElementById("profileDescr").getInnerText();
		//entityDescr = entityDescr.toLowerCase();		
		//Changed by Sandeep S. on 20-MAR-18 [local storage & indexed db related changes]
		
		//Comment by shrutika on 19-04-18 [Start] for remove site code from local storage.
		/*String entityDescr = E12Storage.getItemLocalStorage("userEntityDescrId");
		if( entityDescr == "" || entityDescr == null)
		{
			//Added by Shrutika on 01-02-18 for display site code below the user name when login.
			entityDescr = E12Constants.siteCode;
			//entityDescr = DOM.getElementById("profileDescr").getInnerText();
			//entityDescr = entityDescr.toLowerCase();
		}*/
		// Commented by Pankaj R to show site description
		// String entityDescr = E12Constants.siteCode;
		String entityDescr = E12Constants.siteDescr;
		//Comment by shrutika on 19-04-18 [End] for remove site code from local storage.
		E12CommonUtils.printOnConsole("entityDescr : "+entityDescr);
		Label entityDescrLbl = new Label(entityDescr);
		//Added by Shrutika on 01-02-18 for display site description on the mouse over of site code.
		entityDescrLbl.setTitle(E12Constants.siteDescr);
		entityDescrLbl.setStyleName("entityDescrLbl");
		entityDescrLbl.getElement().setId("userEntityDescrId");
		
		FlowPanel userNameFlwPnl = new FlowPanel();
		userNameFlwPnl.add(userNameLbl);
		userNameFlwPnl.add(entityDescrLbl);
		
		HorizontalPanel userNameHPnl = new HorizontalPanel();
		userNameHPnl.add(userImage);
		userNameHPnl.add(userNameFlwPnl);
		userNameHPnl.setTitle(E12Constants.constants.setClickToLogout());
		
		return userNameHPnl;
	}
	
	private void updateHeader() 
	{
		E12CommonUtils.printOnConsole(".........HDR 3.2");
		if( E12Global.isGalaxy() )
		{
			//TODO:
			userImageHB.setVisible(false);
			userImageHB.getElement().setAttribute("style", "display:none;");
			userImageHB.removeFromParent();
			userSetting.setVisible(false);
			userSetting.getElement().setAttribute("style", "display:none;");
			e12ShortcutPanel.setVisible(false);
			e12ShortcutPanel.getElement().setAttribute("style", "display:none;");
			headerDiv.setHeight("171px");
			headerDiv.setStyleName("headerDiv");
			home.getElement().getParentElement().setAttribute("style", "padding-right: 8px; padding-top:11px;");
			workflow.getElement().getParentElement().setAttribute("style", "padding-right: 8px; padding-top:11px;");
			//Temporary as per KB sir
//			help.setVisible(false);
//			help.getElement().setAttribute("style", "display:none;");
			//Temporary as per KB sir(Social component is not completed)
			/*Commented by Pankaj R on 07-Nov-16 to show Social Component in Galaxy Mode [START]*/
//			social.setVisible(false);
//			social.getElement().setAttribute("style", "display:none;");
			/*Commented by Pankaj R on 07-Nov-16 to show Social Component in Galaxy Mode [START]*/
		}
		else
		{
//			notifyImage.setVisible(false);
//			notifyImage.getElement().setAttribute("style", "display:none;");
//			notifyButton.setVisible(false);
//			notifyButton.getElement().setAttribute("style", "display:none;");
			//Added by Shivaji on 26-May-205 [ To hide TagLine in Non galexy]-Start 
			taglineMetis.setVisible(false);
			taglineMetis.getElement().setAttribute("style", "display:none;");
			//Added by Shivaji on 26-May-205 [ To hide TagLine in Non galexy]-End
			e12NavigateTabBar.setVisible(false);
			e12NavigateTabBar.getElement().setAttribute("style", "display:none;");
			workflow.setVisible(false);
			workflow.getElement().setAttribute("style", "display:none;");
			home.setVisible(false);
			home.getElement().setAttribute("style", "display:none;");
			help.setVisible(false);
			help.getElement().setAttribute("style", "display:none;");
			social.setVisible(false);
			social.getElement().setAttribute("style", "display:none;");
			//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] Start
			devloperConsole.setVisible(false);
			devloperConsole.getElement().setAttribute("style", "display:none;");
			//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] End
			e12ApplicationMenuBar.setVisible(false);
			e12ApplicationMenuBar.getElement().setAttribute("style", "display:none;");
			userNamePanel.setVisible(false);
			userNamePanel.getElement().setAttribute("style", "display:none;");
			headerDiv.setHeight("50px");
		}
	}
	
	@UiHandler ( "home" )
	void onHome(ClickEvent event)
	{
		e12ApplicationMenuBar.selectApplication("HOME_OPT");
		home.setResource(Resources.INSTANCE.homeImg());
		workflow.setResource(Resources.INSTANCE.workflowGrayImg());
		help.setResource(Resources.INSTANCE.helpGrayImg());
		social.setResource(Resources.INSTANCE.socialGrayImg());
		//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] 
		devloperConsole.setResource(Resources.INSTANCE.devloperConsoleGrayImg());
		//BaseE12.e12MenuPanel.updateAccordins("EXPLORER");
		workflow.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				workflow.setResource(Resources.INSTANCE.workflowImg());
			}
		});
		workflow.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				workflow.setResource(Resources.INSTANCE.workflowGrayImg());
			}
		});
		home.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				home.setResource(Resources.INSTANCE.homeImg());
			}
		});
		home.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				home.setResource(Resources.INSTANCE.homeImg());
			}
		});
		help.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				help.setResource(Resources.INSTANCE.helpImg());
			}
		});
		help.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				help.setResource(Resources.INSTANCE.helpGrayImg());
			}
		});
		//Added by Prajyot on 06AUG2015[W15DSUN015 - Social Enterprise Platform]
		social.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				social.setResource(Resources.INSTANCE.socialImg());
			}
		});
		social.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				social.setResource(Resources.INSTANCE.socialGrayImg());
			}
		});
		//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] Start
		devloperConsole.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				devloperConsole.setResource(Resources.INSTANCE.devloperConsoleImg());
			}
		});
		devloperConsole.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				devloperConsole.setResource(Resources.INSTANCE.devloperConsoleGrayImg());
			}
		});
		//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] End
	}
	
	@UiHandler ( "help" )
	void onHelp(ClickEvent event)
	{
		//e12ApplicationMenuBar.selectApplication("HELP_OPT");
		home.setResource(Resources.INSTANCE.homeGrayImg());
		workflow.setResource(Resources.INSTANCE.workflowGrayImg());
		social.setResource(Resources.INSTANCE.socialGrayImg());
		//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] 
		devloperConsole.setResource(Resources.INSTANCE.devloperConsoleGrayImg());
		//help.setResource(Resources.INSTANCE.helpImg());
		BaseE12.e12MenuPanel.updateAccordins("HELP");
		workflow.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				workflow.setResource(Resources.INSTANCE.workflowImg());
			}
		});
		workflow.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				workflow.setResource(Resources.INSTANCE.workflowGrayImg());
			}
		});
		home.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				home.setResource(Resources.INSTANCE.homeImg());
			}
		});
		home.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				home.setResource(Resources.INSTANCE.homeGrayImg());
			}
		});
		help.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				help.setResource(Resources.INSTANCE.helpImg());
			}
		});
		help.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				//help.setResource(Resources.INSTANCE.helpImg());
				help.setResource(Resources.INSTANCE.helpImg());
			}
		});

		//Added by Prajyot on 06AUG2015[W15DSUN015 - Social Enterprise Platform]Start
		social.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				social.setResource(Resources.INSTANCE.socialImg());
 			}
 		});
		social.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				social.setResource(Resources.INSTANCE.socialGrayImg());
 			}
 		});
		//Added by Prajyot on 06AUG2015[W15DSUN015 - Social Enterprise Platform]Ends
		//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] Start
		devloperConsole.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				devloperConsole.setResource(Resources.INSTANCE.devloperConsoleImg());
 			}
 		});
		devloperConsole.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				devloperConsole.setResource(Resources.INSTANCE.devloperConsoleGrayImg());
 			}
 		});
		//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] End
	}
	
	//Added by Pravin K on 23-JAN-19 [for social count] START
	@UiHandler("socialPending")
	void onSialPending(ClickEvent event)
	{
		onSocial(event);
	}
	//Added by Pravin K on 23-JAN-19 [for social count] END
	 
	//Added by Prajyot on 06AUG2015[W15DSUN015 - Social Enterprise Platform]Start
	@UiHandler ( "social" )
	void onSocial(ClickEvent event)
	{
		e12ApplicationMenuBar.selectApplication("SOC_OPT");
		social.setResource(Resources.INSTANCE.socialImg());
		//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ]
		devloperConsole.setResource(Resources.INSTANCE.devloperConsoleGrayImg());
		help.setResource(Resources.INSTANCE.helpGrayImg());
		home.setResource(Resources.INSTANCE.homeGrayImg());
		workflow.setResource(Resources.INSTANCE.workflowGrayImg());
		BaseE12.e12MenuPanel.updateAccordins("SOCIAL");
		
		workflow.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				workflow.setResource(Resources.INSTANCE.workflowImg());
			}
		});
		workflow.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				workflow.setResource(Resources.INSTANCE.workflowGrayImg());
			}
		});
		home.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				home.setResource(Resources.INSTANCE.homeImg());
			}
		});
		home.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				home.setResource(Resources.INSTANCE.homeGrayImg());
			}
		});
		help.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				help.setResource(Resources.INSTANCE.helpImg());
			}
		});
		help.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				//help.setResource(Resources.INSTANCE.helpImg());
  				help.setResource(Resources.INSTANCE.helpGrayImg());
			}
 		});
		social.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				social.setResource(Resources.INSTANCE.socialImg());
			}
		});
		social.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				social.setResource(Resources.INSTANCE.socialImg());
			}
		});
		//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] Start
		devloperConsole.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				devloperConsole.setResource(Resources.INSTANCE.devloperConsoleGrayImg());
			}
		});
		devloperConsole.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				devloperConsole.setResource(Resources.INSTANCE.devloperConsoleImg());
			}
		});
		//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] End
 	}
	//Added by Prajyot on 06AUG2015[W15DSUN015 - Social Enterprise Platform]Ends
	//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] Start
	@UiHandler ( "devloperConsole" )
	void onDevloperConsole(ClickEvent event)
	{
		E12Constants.lastSelectedMenuOpt = E12Constants.conApplNm;
		e12ApplicationMenuBar.selectApplication("DEV_OPT");
		devloperConsole.setResource(Resources.INSTANCE.devloperConsoleImg());
		social.setResource(Resources.INSTANCE.socialGrayImg());
		help.setResource(Resources.INSTANCE.helpGrayImg());
		home.setResource(Resources.INSTANCE.homeGrayImg());
		workflow.setResource(Resources.INSTANCE.workflowGrayImg());
		
		workflow.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				workflow.setResource(Resources.INSTANCE.workflowImg());
			}
		});
		workflow.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				workflow.setResource(Resources.INSTANCE.workflowGrayImg());
			}
		});
		home.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				home.setResource(Resources.INSTANCE.homeImg());
			}
		});
		home.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				home.setResource(Resources.INSTANCE.homeGrayImg());
			}
		});
		help.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				help.setResource(Resources.INSTANCE.helpImg());
			}
		});
		help.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
  				help.setResource(Resources.INSTANCE.helpGrayImg());
			}
 		});
		social.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				social.setResource(Resources.INSTANCE.socialImg());
			}
		});
		social.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				social.setResource(Resources.INSTANCE.socialImg());
			}
		});
		
		//POOJA S
		
		devloperConsole.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				devloperConsole.setResource(Resources.INSTANCE.devloperConsoleImg());
			}
		});
		devloperConsole.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				devloperConsole.setResource(Resources.INSTANCE.devloperConsoleImg());
			}
		});
 	}
	//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] End
	// Added by Shivaji on 26-May-2015 [To add Tag Line ]-Start
		/**
		 * This method will add Tag Line  
		 * @return
		 */
		public HorizontalPanel getTagLinePanel()
		{
			HorizontalPanel tagLinePanel = new HorizontalPanel();
			tagLinePanel.setStyleName("tagLineHPanel");
			try
			{
				if( DOM.getElementById("tagLine").getInnerText() != null )
				{
					tagLine = DOM.getElementById("tagLine").getInnerText();
					
					tagLine = E12CommonUtils.checkNull( tagLine );
					Label tagLineLabel = new Label( );
					
					if ( ! "".equals( tagLine ) )
					{
						tagLineLabel.setText( tagLine );
					}
					tagLineLabel.addStyleName("tagLineLabel");
					tagLinePanel.add( tagLineLabel );

					//Changed by Pankaj P on 22/06/2021 [to resolve the search-bar issue in updated chrome browser] STRAT
					E12CommonUtils.printOnConsole("getTagLinePanel :: tagLine : ["+ tagLine +"]");
					if ( "".equals( tagLine ) )
					{
						tagLinePanel.setVisible(false);
						tagLinePanel.getElement().setAttribute("style", "display:none;");
					}
					//Changed by Pankaj P on 22/06/2021 [to resolve the search-bar issue in updated chrome browser] END
				}
			}
			catch (Exception ex) {
			   Window.alert("exception in getTagLinePanel" + ex.getMessage() + "]" );
			}
			return tagLinePanel;
			
		}
		// Added by Shivaji on 26-May-2015 [To add Tag Line ]-End
		//Added Pravin K on 16-JAN-19	[To show group post notification] Start
		private native void hideSocialNotificationCount()/*-{
			try{
				$wnd.customLog("in hideSocialNotificationCount");
				var socialCounterEle = $doc.getElementById('social-pending');
				if(socialCounterEle)
				{
					socialCounterEle.innerText = '';
					socialCounterEle.style.display='none';
				}
			}
			catch(err)
			{
				$wnd.customLog("Error in hideSocialNotificationCount "+err);
			}
		}-*/;

		private native void setGropupNotificationCount()/*-{
			try{
				$wnd.customLog("in setGropupNotificationCount");
				var socialPenting = $wnd.socialPendig;
				if(!socialPenting)
				{
					socialPenting = {'0000000005_cnt':5,'0000000004_cnt':4,'SYSTEM_cnt':3};
					$wnd.customLog("in setGropupNotificationCount socialPenting : ",socialPenting);
				}
			  $wnd.customLog("-- group-----------");
				for( groupId in socialPenting)
				{
					if(groupId)
					{
						var groupCount = socialPenting[groupId];
						$wnd.customLog("-- groupCount : ",groupCount,",panelId : ",groupId);
						this.@ibase.e12ria.client.E12HeaderPanel::showAndUpdateGroupCount(Ljava/lang/String;Ljava/lang/String;)(groupId, groupCount);
					}
				}
			}
			catch(err)
			{
				$wnd.customLog("Error in setGropupNotificationCount "+err);
			}
		}-*/;
		
		private native void showAndUpdateGroupCount(String panelId, String count)/*-{
			try{
				$wnd.customLog("-- showAndUpdateGroupCount panelId : ",panelId," Count: ",count);
				var socialCounterEle = $doc.getElementById(panelId);
				$wnd.customLog("-- showAndUpdateGroupCount socialCounterEle : ",socialCounterEle);
				if(socialCounterEle)
				{
					socialCounterEle.innerText = count;
					var displayStyle = socialCounterEle.style.display;
					$wnd.customLog("displayStyle : ",displayStyle);
					if( displayStyle ==='none' )
					{
						socialCounterEle.style.display='inline-block';
					}
				}
			}
			catch(err)
			{
				$wnd.customLog("Error in showAndUpdateGroupCount "+err);
			}
	}-*/;
	//Added Pravin K on 16-JAN-19	[To show group post notification] End
}	  